<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Home Page
    |--------------------------------------------------------------------------
    |
    | resources/views/home.blade.php
    |
    */

    'Log in' => 'Anmelden',
    'Register' => 'Registrieren',

    'Dashboard' => 'Dashboard',
    'Copyright' => 'Urheberrecht',
    'Made with' => 'Gemacht mit',
    'by' => 'von',


    'HOME.MESSAGE' => '
    <p>Nehmen Sie die Kontrolle über Ihre Online-Präsenz mit <a href="https://linkstack.org/"><strong>LinkStack</strong></a>
    , der datenschutzorientierten, Open-Source <strong>Link-Management-Plattform</strong>. 
    Erstellen Sie eine anpassbare Profilseite, um <strong> alle Ihre wichtigen Links an einem Ort zu verwalten</strong> 
    und Ihren Besuchern ein nahtloses Browsing-Erlebnis zu bieten.</p>
    ',


    /*
    |--------------------------------------------------------------------------
    | Demo Page/Home Page Example Page
    |--------------------------------------------------------------------------
    |
    | resources/views/demo.blade.php
    |
    */
    
    'Example page' => 'Beispielseite',


    /*
    |--------------------------------------------------------------------------
    | Authentication Pages
    |--------------------------------------------------------------------------
    |
    | Login, Register, Forgot Password, Reset Password etc.
    | This includes authentication emails like password reset and email verification.
    | resources/views/auth
    |
    */

    # Login Page
    'Sign In' => 'Anmelden',
    'Login to stay connected' => 'Melden Sie sich an, um in Verbindung zu bleiben',
    'Email' => 'Email',
    'Password' => 'Passwort',
    'Remember Me' => 'Angemeldet bleiben',
    'Forgot Password?' => 'Passwort vergessen?',
    'or sign in with other accounts?' => 'oder mit anderen Konten anmelden?',
    'Don’t have an account?' => 'Sie haben noch kein Konto?',
    'Click here to sign up' => 'Klicken Sie hier, um sich anzumelden',


    # Reset password
    'Forgot your password?' => 'Haben Sie Ihr Passwort vergessen?',
    'No problem' => 'Kein Problem. Teilen Sie uns einfach Ihre E-Mail-Adresse mit und wir senden Ihnen per E-Mail einen Link zum Zurücksetzen Ihres Passworts, mit dem Sie ein neues Passwort auswählen können.',
    'Email Password Reset Link' => 'Link zum Zurücksetzen des Passworts per E-Mail senden',


    # Register Page
    'Sign Up' => 'Anmeldung',
    'Register to stay connected' => 'Registrieren Sie sich, um in Verbindung zu bleiben',
    'Display Name' => 'Anzeigename',
    'Confirm Password' => 'Bestätige das Passwort',
    'Already have an account?' => 'Sie haben bereits ein Konto?',
    'Click here to sign in' => 'Hier klicken um sich anzumelden',


    # Pending verification by admin
    'Verification Status' => 'Verifizierungsstatus',
    'auth_pending' => 'Die Verifizierung Ihres Kontos steht noch aus',
    'auth_unverified' => 'Ihr Konto ist derzeit nicht verifiziert und erfordert eine manuelle Verifizierung durch einen Administrator.',
    'Log out' => 'Ausloggen',


    # Password confirmation
    'auth_password' => 'Dies ist ein sicherer Bereich der Anwendung. Bitte bestätigen Sie Ihr Passwort, bevor Sie fortfahren.',
    'Confirm' => 'Bestätigen',


    # Password Reset
    'Reset Password' => 'Passwort zurücksetzen',
    'Enter a new password' => 'Geben Sie ein neues Kennwort ein',


    # Test email
    'Test E-Mail' => 'Test-Email',


    # Signup notification email
    'A new user has registered on' => 'Ein neuer Benutzer hat sich registriert',
    'and is awaiting verification' => 'und wartet auf die Bestätigung',
    'The user' => 'Der Benutzer',
    'with the email' => 'mit der E-Mail',
    'has registered a new account on' => 'hat ein neues Konto registriert',
    'and is awaiting confirmation by an admin' => 'und wartet auf die Bestätigung durch einen Administrator.',
    'Click' => 'Klicken',
    'here' => 'Hier',
    'to verify the user' => 'um den Benutzer zu verifizieren.',
    'Manage Users' => 'Benutzerverwaltung',


    # Email verification email
    'auth_thanks' => 'Danke für\'s Registrieren! Bevor Sie beginnen, können Sie Ihre E-Mail-Adresse überprüfen, indem Sie auf den Link klicken, den wir Ihnen gerade per E-Mail zugesandt haben. Wenn Sie die E-Mail nicht erhalten haben, senden wir Ihnen gerne eine neue zu. Wenn Sie die E-Mail nicht innerhalb weniger Minuten sehen, überprüfen Sie Ihren Junk-Mail- oder Spam-Ordner.',
    'auth_verification' => 'Ein neuer Bestätigungslink wurde an die E-Mail-Adresse gesendet, die Sie bei der Registrierung angegeben haben.',
    'Resend Verification Email' => 'Bestätigungsmail erneut senden',


    /*
    |--------------------------------------------------------------------------
    | Styling Slide In
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */

    'Settings' => 'Einstellungen',
    'Scheme' => 'Farbschema',
    'Auto' => 'Auto',
    'Dark' => 'Dunkel',
    'Light' => 'Hell',
    'Color Customizer' => 'Farbanpassung',
    'Sidebar Color' => 'Farbe der Seitenleiste',
    'Default' => 'Standard',
    'Color' => 'Farbe',
    'Transparent' => 'Transparent',
    'Sidebar Types' => 'Seitenleistentypen',
    'Mini' => 'Mini',
    'Hover' => 'Schwebend',
    'Boxed' => 'Verpackt',
    'Sidebar Active Style' => 'Aktiver Stil der Seitenleiste',
    'Rounded One Side' => 'Eine Seite abgerundet',
    'Rounded All' => 'Alles abgerundet',
    'Pill One Side' => 'Pille eine Seite',
    'Pill All' => 'Pille Alle',


    /*
    |--------------------------------------------------------------------------
    | Site customization
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/site.blade.php
    |
    */

    'Home' => 'Startseite',
    'Add Link' => 'Link hinzufügen',
    'Administration' => 'Verwaltung',
    'Admin' => 'Administrator',
    'Config' => 'Konfig',
    'Manage Users' => 'Benutzerverwaltung',
    'Footer Pages' => 'Fußzeilen',
    'Site Customization' => 'Seitenanpassung',
    'Site Logo' => 'Site-Logo',
    'Personalization' => 'Personalisierung',
    'Links' => 'Links',
    'Appearance' => 'Aussehen',
    'Themes' => 'Themen',
    'Site logo' => 'Seitenlogo',
    'Favicon' => 'Favicon',
    'Home message' => 'Startseitennachricht',


    /*
    |--------------------------------------------------------------------------
    | Navbar
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */
    
    'View Page' => 'Seite anzeigen',
    'Share your profile' => 'Teile dein Profil',
    'Share your profile:' => 'Teile dein Profil:',
    'Error sharing:' => 'Fehler beim Teilen:',
    'Text copied to clipboard!' => 'Text in die Zwischenablage kopiert!',
    'Error copying text:' => 'Fehler beim Kopieren des Textes:',
    'QR Code' => 'QR-Code',
    'Scan QR Code' => 'QR-Code scannen',
    'QR code could not be generated' => 'QR-Code konnte nicht generiert werden',
    'Reason:' => 'Grund:',

    # QR Code dropdown
    'Close' => 'Schließen',
    'Dismiss' => 'Verwerfen',
    
    # Notification dropdown
    'All Notifications' => 'Alle Benachrichtigungen',

    # Updater dropdown
    'Updater' => 'Updater',
    'Beta Mode' => 'Beta-Modus',
    'Local version' => 'Lokale Version',
    'Latest beta' => 'Neueste Beta',
    'Run updater' => 'Updaten',
    'Update available' => 'Update verfügbar',
    'Up to date' => 'Auf dem neuesten Stand',
    'Check again' => 'Erneut überprüfen',

    # User section in navbar
    'Administrator' => 'Administrator',
    'Verified user' => 'Verifizierter Benutzer',
    'User' => 'Benutzer',
    'Profile' => 'Profil',
    'Styling' => 'Styling',
    'Logout' => 'Ausloggen',


    /*
    |--------------------------------------------------------------------------
    | Dashboard Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/index.blade.php
    |
    */

    # Header with image
    'Hi' => 'Hi',
    'stranger' => 'Fremder',
    'welcome' => 'Willkommen bei :appName!',
    'Set a handle' => 'Legen Sie einen Handle fest',

    # Dashboard Page
    'Total Links:' => 'Gesamte links:',
    'Link Clicks:' => 'Linkklicks:',
    'View/Edit Links' => 'Links anzeigen/bearbeiten',
    'Top Links:' => 'Top-Links:',
    'You haven’t added any links yet' => 'Sie haben noch keine Links hinzugefügt.',
    'clicks' => 'Klicks',
    'Site statistics:' => 'Seitenstatistik:',
    'Total links' => 'Links',
    'Total clicks' => 'Klicks',
    'Total users' => 'Benutzer',
    'Registrations:' => 'Registrierungen:',
    'Last 30 days' => 'Letzte 30 Tage',
    'Last 7 days' => 'Letzten 7 Tage',
    'Last 24 hours' => 'Letzte 24 Stunden',
    'Active users:' => 'Aktive Benutzer:',
    
    

    /*
    |--------------------------------------------------------------------------
    | Button Editor
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/button-editor.blade.php
    |
    */

    'Button Editor' => 'Button-Eneditor',
    'Back' => 'Zurück',
    'Custom Button' => 'Benutzerdefinierter Button',
    'CSS' => 'CSS',
    'background' => 'Hintergrund',
    'gradient' => 'Gradient',
    'Show CSS' => 'CSS anzeigen',
    'Custom CSS' => 'Benutzerdefiniertes CSS',
    'Save' => 'Speichern',
    'Reset to default' => 'Zurücksetzen',
    'Result' => 'Ergebnis:',
    'Custom Icon' => 'Benutzerdefiniertes Symbol',
    'Custom Alert' => 'Der Short Code Ihres benutzerdefinierten Symbols enthält nicht die Zeichenfolge „fa-“. Verwenden Sie immer Symbole im Format: fa-ghost, zum Beispiel.',
    'cb.description.1-4' => 'Benutzerdefinierte Symbole können über Font Awesome zu Schaltflächen hinzugefügt werden. Sie können jedes Symbol aus der unten stehenden Liste verwenden. Klicken Sie auf die Schaltfläche "Alle Symbole anzeigen", um auf diese Liste zuzugreifen. Jedes Symbol in dieser Liste hat einen Kurzcode, den Sie kopieren und im Feld für benutzerdefinierte Symbole eingeben können.',
    'cb.description.2-4' => 'Jeder Kurzcode für ein Symbol besteht aus einem Präfix und einem Hauptteil. Wenn der Kurzcode kein Markensymbol ist, können Sie den Code einfach im Format "fa-Symbolname" eingeben. Die Formatierung "fa-..." ist hier wichtig. Zum Beispiel "fa-code".',
    'cb.description.3-4' => 'Wenn der Kurzcode ein Markensymbol ist, ist es wichtig, vor dem Kurzcode einen "fab" einzuschließen. Auch hier gilt immer noch die Formatierung "fa-...". Zum Beispiel "fab fa-github".',
    'cb.description.4-4' => 'Um Ihren Symbolen Farbe zu verleihen, können Sie einfach den Farbnamen ausschreiben oder den HEX-Wert vor dem Symbol eingeben, gefolgt von einem Semikolon. Hier ist es wichtig, die Farbe vor dem Symbolkurzcode anzugeben und der Farbcode muss mit einem Semikolon enden.<br>Sie finden eine Liste der verfügbaren Farben <a href="https://www.w3schools.com/cssref/css_colors.asp" target="_blank">hier</a>.',
    'Style' => 'Stil',
    'Prefix' => 'Präfix',
    'Icon' => 'Symbol',
    'Short Code' => 'Short Code',
    'Regular' => 'Regulär',
    'Brands' => 'Marken',
    'Color name' => 'Farbname',
    'Color HEX' => 'Farbe HEX',
    'Color HEX1' => 'Farbe HEX',
    'Update icon' => 'Symbol aktualisieren',
    'See all icons' => 'Alle Symbole anzeigen',


    /*
    |--------------------------------------------------------------------------
    | Edit Link Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/edit-link.blade.php
    |
    */

    'Edit' => 'Bearbeiten',
    'Add' => 'Neuer',
    'Block' => 'Block',
    'Blocks' => 'Blöcke:',
    'Select Block' => 'Block wählen',
    'Toggle Dropdown' => 'Dropdown-Liste umschalten',
    'Cancel' => 'Abbrechen',
    'Save and Add More' => 'Speichern und weitere hinzufügen',
    'Click to change link blocks' => 'Klicken Sie hier, um Blöcke zu ändern',
    'Click for a list of available link blocks' => 'Klicken Sie hier, um eine Liste der verfügbaren Blöcke anzuzeigen',


    /*
    |--------------------------------------------------------------------------
    | Links Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/links.blade.php
    |
    */

    'My Links' => 'Meine Links',
    'Add new Link' => 'Neuen Link hinzufügen',
    'No Link Added' => 'Sie haben noch keine Links hinzugefügt.',
    'Download' => 'Herunterladen',
    'Clicks' => 'Klicks',
    'Preview' => 'Vorschau:',
    'No compatible browser' => 'Ihr Browser ist nicht kompatibel',
    'Page Icons' => 'Seitensymbole',
    'Save links' => 'Links speichern',

    # Tooltips
    'Customize' => 'Anpassen',
    'Delete' => 'Löschen',
    'Clear icon cache' => 'Symbol-Cache leeren',
    
    'confirm_delete' => 'Sind Sie sicher, dass Sie :title löschen möchten?',


    /*
    |--------------------------------------------------------------------------
    | "My Profile"/Appearance Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/page.blade.php
    |
    */

    'My Profile' => 'Mein Profil',
    'Profile Picture' => 'Profilbild',
    'Page URL' => 'Seiten-URL',
    'Display name' => 'Anzeigename',
    'Name' => 'Name',
    'Page Description' => 'Seitenbeschreibung',
    'Show checkmark' => 'Häkchen anzeigen',
    'disableverified' => 'Sie sind ein verifizierter Benutzer. Mit dieser Einstellung können Sie Ihr Häkchen auf Ihrer Seite ausblenden.',
    'Show share button' => 'Teilen-Button anzeigen',
    'disablesharebutton' => 'Mit dieser Einstellung können Sie die Schaltfläche „Teilen“ auf Ihrer Seite ausblenden.',
    'Open links in new tab' => 'Links in neuem Tab öffnen',
    'openlinksnewtab' => 'Diese Einstellung bestimmt, ob Ihre Links auf Ihrer Seite im gleichen oder einem neuen Tab geöffnet werden.',


    /*
    |--------------------------------------------------------------------------
    | Personal Settings Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/profile.blade.php
    |
    */

    'Account Settings' => 'Account Einstellungen',
    'Change email' => 'E-Mail Ändern',
    'Change password' => 'Kennwort ändern',
    'Export user data' => 'Benutzerdaten exportieren',
    'Export your user data' => 'Exportieren Sie Ihre Benutzerdaten, um sie auf eine andere Instanz zu übertragen.',
    'Export all data' => 'Alle Daten exportieren',
    'Export links only' => 'Nur Links exportieren',
    'Import user data' => 'Benutzerdaten importieren',
    'import.user.alert' => 'Sind Sie sicher, dass Sie diese Datei importieren möchten? Diese Aktion wird alle Ihre aktuellen Daten, einschließlich Links, ersetzen!',
    'Import your user data from another instance' => 'Importieren Sie Ihre Benutzerdaten von einer anderen Instanz.',
    'Import your user data' => 'Importieren Sie Ihre Benutzerdaten von einer anderen Instanz.',
    'Import' => 'Importieren',
    'Delete your account' => 'Lösche deinen Account',
    'You are about to delete' => 'Sie sind dabei, Ihr Konto zu löschen!',
    'You are about to delete This action cannot be undone' => 'Sie sind dabei, Ihr Konto zu löschen! Diese Aktion kann nicht rückgängig gemacht werden.',
    'Delete account' => 'Konto löschen',
    
    # Alerts
    'Profile updated successfully!' => 'Profil erfolgreich aktualisiert!',
    'An error occurred while updating your profile.' => 'Beim Aktualisieren Ihres Profils ist ein Fehler aufgetreten.',
    
    'That handle has already been taken' => 'Dieser Name ist bereits vergeben.',
    'The selected file must be an image' => 'Die ausgewählte Datei muss ein Bild sein.',
    'The image must be' => 'Unterstützte Formate:',
    'The image size should not exceed 2MB' => 'Die Bildgröße darf 2 MB nicht überschreiten.',
    'Please select an image' => 'Bitte wählen Sie ein Bild aus.',


    /*
    |--------------------------------------------------------------------------
    | Themes Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme.blade.php
    |
    */

    'Select a theme' => 'Wähle ein Thema',
    'Select theme' => 'Thema wählen',
    'Custom background' => 'Benutzerdefinierter Hintergrund',
    'No image selected' => 'Kein Bild ausgewählt',
    'Remove background' => 'Hintergrund entfernen',
    'Manage themes' => 'Themen verwalten',
    'Loading...' => 'Wird geladen...',
    'Upload themes' => 'Hochladen',
    'Delete themes' => 'Themen löschen',
    'Download themes' => 'Laden Sie Themen herunter',
    'Delete a theme' => 'Löschen Sie ein Thema',


    /*
    |--------------------------------------------------------------------------
    | Theme Updater
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme-updater.blade.php
    |
    */

    'Theme Updater' => 'Theme-Updater',
    'Theme name' => 'Themenname:',
    'Update status' => 'Update Status:',
    'Version' => 'Ausführung:',
    'Error!' => 'Fehler!',
    'Update manually' => 'Manuell aktualisieren',
    'Update all themes' => 'Aktualisieren Sie alle Themen',


    /*
    |--------------------------------------------------------------------------
    | Edit User Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/edit-user.blade.php
    |
    */
    
    'Edit User' => 'Benutzer bearbeiten',
    'Logo' => 'Logo',
    'Page description' => 'Seitenbeschreibung',
    'Role' => 'Rolle',


    /*
    |--------------------------------------------------------------------------
    | Links Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Title' => 'Titel',


    /*
    |--------------------------------------------------------------------------
    | Links Page (Admin)
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Link' => 'Link',


    /*
    |--------------------------------------------------------------------------
    | PHP info Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/phpinfo.blade.php
    |
    */

    'Information about PHP’s configuration' => 'Informationen zur PHP-Konfiguration',
    'Outputs information about the current state of PHP' => 'Gibt Informationen über den aktuellen Zustand von PHP aus',


    /*
    |--------------------------------------------------------------------------
    | Delete themes page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/theme.blade.php
    |
    */

    'Delete theme' => 'Theme löschen',


    /*
    |--------------------------------------------------------------------------
    | Manage Users Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/users.blade.php
    |
    */

    'Users:' => 'Benutzer:',
    'Search user' => 'Benutzer suchen',
    'ID' => 'ID',
    'E-Mail' => 'Email',
    'Page' => 'Seite',
    'Created at' => 'Hinzugefügt am',
    'Last seen' => 'Zuletzt gesehen',
    'Status' => 'Status',
    'Action' => 'Aktion',
    'N/A' => 'N / A',
    'Pending' => 'Ausstehend',
    'Verified' => 'Verifiziert',
    'Approved' => 'Zugelassen',
    'Add new user' => 'Neuen Benutzer hinzufügen',

    # Tooltips
    'tt.Delete' => 'Löschen',
    'tt.Impersonate' => 'Benutzer nachahmen',
    'tt.Edit' => 'Bearbeiten',
    'tt.All links' => 'Alle Links',

    'confirm.delete.user' => 'Sind Sie sicher, dass Sie diesen Benutzer löschen möchten? \\nDiese Aktion kann nicht rückgängig gemacht werden!',

    # Date Format
    'date.format' => 'd/m/Y',

    'days ago' => 'Vor Tagen',
    '1 day ago' => 'Vor 1 Tag',
    'Today' => 'Heute',
    '1 year ago' => 'vor 1 Jahr',
    'years ago' => 'Jahre zuvor',


    /*
    |--------------------------------------------------------------------------
    | Config Page
    |--------------------------------------------------------------------------
    |
    | resources/views/components/config/
    | resources/views/panel/config-editor.blade.php
    |
    */

    'Advanced Config' => 'Erweiterte Konfiguration',
    'Take Backup' => 'Backup',
    'All Backups' => 'Alle Backups',
    'Diagnosis' => 'Diagnose',

    'Alternative Config Editor' => 'Alternativer Konfigurationseditor',
    'Use the Alternative Config Editor to edit the config directly' => 'Verwenden Sie den Alternative Konfigurationseditor, um die Konfiguration direkt zu bearbeiten',

    'PHP info' => 'PHP-Info',
    'Display debugging information about your PHP setup' => 'Zeigt Debugging-Informationen zu Ihrem PHP-Setup an',

    'Jump directly to:' => 'Direkt springen zu:',

    'Application' => 'Anwendung',
    'Panel settings' => 'Panel-Einstellungen',
    'Security' => 'Sicherheit',
    'Advanced' => 'Expertenoptionen',
    'SMTP' => 'SMTP',
    'Footer links' => 'Fußzeilen-Links',
    'Debug' => 'Debug',
    'Language' => 'Sprache',

    'default' => 'Standard',
    'Apply' => 'Anwenden',

    'AC.description' => 'Ermöglicht die Bearbeitung des Frontends Ihrer Website. Diese Datei ermöglicht unter anderem die Anpassung von: Startseite, Links, Titeln, Google Analytics und Meta-Tags.',
    'Advanced Configuration file.' => 'Erweiterte Konfigurationsdatei.',
    'Restore defaults' => 'Standardeinstellungen wiederherstellen',

    'Backup' => 'Sicherung',
    'You can back up your entire instance:' => 'Sie können Ihre gesamte Instanz sichern:',
    'The backup system won’t save more than two backups at a time' => 'Das Backup-System speichert nicht mehr als zwei Backups gleichzeitig.',
    'Backup Instance' => 'Backup-Instanz',

    'wtrue' => 'Alles funktioniert wie erwartet!',
    'wfalse' => 'In diese Datei kann nicht geschrieben werden. Dies kann den ordnungsgemäßen Betrieb beeinträchtigen.',
    'utrue' => 'Ihre Sicherheit ist gefährdet. Auf diese Datei kann jeder zugreifen. Es besteht sofortiger Handlungsbedarf!',
    'ufalse' => 'Alles funktioniert wie erwartet!',
    'unull' => 'Etwas ist schief gelaufen. Dies kann normal sein, wenn Sie hinter einem Proxy- oder Docker-Container arbeiten.',
    'Debugging information' => 'Debugging-Informationen',
    'security.risk' => 'Ihre Sicherheit ist gefährdet. Einige Dateien können von jedem eingesehen werden. Sofortiges Handeln ist erforderlich! Klicken Sie auf diese Nachricht, um mehr zu erfahren.',
    'security.risk.1-3' => 'Hier können Sie leicht überprüfen, ob kritische Systemdateien von extern zugänglich sind. Es ist wichtig, dass auf diese Dateien nicht zugegriffen werden kann, da ansonsten Benutzerdaten wie Passwörter durchsickern könnten. Einträge, die mit einem',
    'security.risk.2-3' => 'gekennzeichnet sind, können von extern nicht zugegriffen werden. Einträge, die mit einem',
    'security.risk.3-3' => 'gekennzeichnet sind, können von jedem eingesehen werden und erfordern sofortiges Handeln zum Schutz Ihrer Daten.',
    'Hover for more' => 'Mauszeiger über Symbole bewegen.',
    'Write access' => 'Schreibzugriff',
    'Write access.description.1-3' => 'Hier können Sie leicht überprüfen, ob wichtige Systemdateien beschreibbar sind. Dies ist wichtig, damit jede Funktion ordnungsgemäß funktioniert. Einträge, die mit einem',
    'Write access.description.2-3' => 'markiert sind, funktionieren wie erwartet. Einträge, die mit einem',
    'Write access.description.3-3' => 'markiert sind, tun es nicht.',
    'File' => 'Datei',
    'Dependencies' => NULL,
    'Required PHP modules' => 'Erforderliche PHP-Module.',
    'PHP Extension' => 'PHP-Erweiterung',
    'No backups found' => 'Keine Backups gefunden',
    'Backup your instance' => 'Sichern Sie Ihre Instanz',

    'Go back' => 'Geh zurück',

    'Strings with a # in front of them are comments and wont affect anything' => 'Zeichenfolgen mit einem # davor sind Kommentare und haben keinerlei Auswirkungen.',

    'Download your updater backups:' => 'Laden Sie Ihre Updater-Backups herunter:',
    'The server will never store more that two backups at a time' => 'Der Server speichert nie mehr als zwei Backups gleichzeitig.',

    'SMTP.title' => 'Verwenden Sie den integrierten SMTP-Server',
    'SMTP.description' => 'Verwendet den von LinkStack bereitgestellten SMTP-Server. Möglicherweise nicht 100 % zuverlässig. Muss deaktiviert werden, um einen benutzerdefinierten SMTP-Server zu verwenden.',
    'SMTP.description.alt' => '(Speichern Sie die Änderungen mit „Änderungen übernehmen“ unten)',
    'Enable' => 'Aktiv',
    'Custom SMTP server:' => 'Benutzerdefinierter SMTP-Server:',
    'Host' => 'Host',
    'Port' => 'Port',
    'Username' => 'Nutzername',
    'Encryption type' => 'Verschlüsselungstyp',
    'From address' => 'Absenderadresse',
    'Apply changes' => 'Änderungen übernehmen',
    'Test E-Mail setup:' => 'E-Mail-Setup testen:',
    'Send Test E-Mail' => 'Test-E-Mail senden',

    'Debug.title' => 'Debug-Modus',
    'Debug.description' => 'Sollte in einer Produktionsumgebung deaktiviert sein. Nützlich zum Debuggen während des Setups.',

    'DISPLAY_FOOTER_HOME.title' => 'Link zur Startseite in Fußzeile anzeigen',
    'DISPLAY_FOOTER_HOME.description' => 'Aktivieren Sie den Home-Fußzeilenlink.',
    'REGISTER_AUTH.title' => 'Aktivieren Sie die E-Mail-Bestätigung',
    'REGISTER_AUTH.description' => 'Legt fest, ob Benutzer ihre E-Mail-Adresse bei der Registrierung bestätigen müssen.',
    'ALLOW_REGISTRATION.title' => 'Registrierung aktivieren',
    'ALLOW_REGISTRATION.description' => 'Legt fest, ob sich Benutzer auf Ihre Anwendung registrieren können.',
    'NOTIFY_EVENTS.title' => 'Benachrichtigungen über Ereignisse',
    'NOTIFY_EVENTS.description' => 'Zeigt eine Benachrichtigung an, wenn ein Ereignis ausgeführt wird.',
    'NOTIFY_UPDATES.title' => 'Bei Updates benachrichtigen',
    'NOTIFY_UPDATES.description' => 'Zeigt eine Benachrichtigung an, wenn ein neues Update verfügbar ist.',
    'DISPLAY_FOOTER.title' => 'Fußzeile anzeigen',
    'DISPLAY_FOOTER.description' => 'Legt fest, ob die Footer-Links angezeigt werden sollen.',
    'DISPLAY_CREDIT.title' => 'Signatur auf Benutzerseiten anzeigen',
    'DISPLAY_CREDIT.description' => 'Legt fest, ob die Signatur auf den Benutzerseiten angezeigt werden soll.',
    'DISPLAY_CREDIT_FOOTER.title' => 'Signatur in der Fußzeile anzeigen',
    'DISPLAY_CREDIT_FOOTER.description' => 'Legt fest, ob die Signatur in der Fußzeile angezeigt werden soll.',
    'HOME_URL.title' => 'Legen Sie eine Benutzerseite als Startseite fest',
    'HOME_URL.description' => 'Legen Sie eine Benutzerseite als Startseite fest. Dadurch wird die vorherige Startseite nach example.com/home verschoben.',
    'ALLOW_USER_HTML.title' => 'Erweiterte Syntax in Benutzerbeschreibungen zulassen',
    'ALLOW_USER_HTML.description' => 'Dadurch können Benutzer spezielle Formatierungen wie Überschriften und Links in ihrer Seitenbeschreibung verwenden. Dies gilt allgemein als sicher.',
    'APP_NAME.title' => 'Anwendungsname',
    'APP_NAME.description' => 'Legt den Titel Ihrer App fest. Durch eine Änderung wird jeder aktive Benutzer abgemeldet.',
    'APP_KEY.title' => 'APP_KEY',
    'APP_KEY.description' => 'APP_KEY',
    'APP_URL.title' => 'APP_URL',
    'APP_URL.description' => 'APP_URL',
    'ENABLE_BUTTON_EDITOR.title' => 'Aktivieren Sie den Button-Editor',
    'ENABLE_BUTTON_EDITOR.description' => 'Legt fest, ob Benutzer ihre eigenen Buttons mit CSS anpassen dürfen.',
    'APP_DEBUG.title' => 'APP_DEBUG',
    'APP_DEBUG.description' => 'APP_DEBUG',
    'APP_ENV.title' => 'APP_ENV',
    'APP_ENV.description' => 'APP_ENV',
    'LOG_CHANNEL.title' => 'LOG_CHANNEL',
    'LOG_CHANNEL.description' => 'LOG_CHANNEL',
    'LOG_LEVEL.title' => 'LOG_LEVEL',
    'LOG_LEVEL.description' => 'LOG_LEVEL',
    'MAINTENANCE_MODE.title' => 'Aktivieren Sie den Wartungsmodus',
    'MAINTENANCE_MODE.description' => 'Zeigt auf allen öffentlichen Seiten eine Wartungsmeldung an. Dadurch werden die Anmeldeseite deaktiviert.',
    'MAIL_MAILER.title' => 'MAIL_MAILER',
    'MAIL_MAILER.description' => 'MAIL_MAILER',
    'MAIL_HOST.title' => 'MAIL_HOST',
    'MAIL_HOST.description' => 'MAIL_HOST',
    'MAIL_PORT.title' => 'MAIL_PORT',
    'MAIL_PORT.description' => 'MAIL_PORT',
    'MAIL_USERNAME.title' => 'MAIL_USERNAME',
    'MAIL_USERNAME.description' => 'MAIL_USERNAME',
    'MAIL_PASSWORD.title' => 'MAIL_PASSWORD',
    'MAIL_PASSWORD.description' => 'MAIL_PASSWORD',
    'MAIL_ENCRYPTION.title' => 'MAIL_ENCRYPTION',
    'MAIL_ENCRYPTION.description' => 'MAIL_ENCRYPTION',
    'MAIL_FROM_ADDRESS.title' => 'MAIL_FROM_ADDRESS',
    'MAIL_FROM_ADDRESS.description' => 'MAIL_FROM_ADDRESS',
    'JOIN_BETA.title' => 'Nehmen Sie am Beta-Programm teil',
    'JOIN_BETA.description' => 'Ermöglicht die Verwendung von Betaversionen beim Update. Lesen Sie mehr darüber <a target=\'_blank\' href=\'https://linkstack.org/b\'>hier</a>.',
    'SKIP_UPDATE_BACKUP.title' => 'Update-Backups überspringen',
    'SKIP_UPDATE_BACKUP.description' => 'Überspringt Backups beim Aktualisieren. Es wird empfohlen, diese Option immer deaktiviert zu lassen. <br>Sie kann jedoch bei einigen Konfigurationen zu Fehlern führen.',
    'CUSTOM_META_TAGS.title' => 'Aktivieren Sie benutzerdefinierte Meta-Tags',
    'CUSTOM_META_TAGS.description' => 'Ermöglicht die Verwendung benutzerdefinierter Meta-Tags im Kopf aller Seiten. Definiert in der erweiterten Konfiguration.',
    'FORCE_HTTPS.title' => 'Erzwinge HTTPS-Links',
    'FORCE_HTTPS.description' => 'Stellt sicher, dass alle Links standardmäßig HTTPS verwenden. Es wird empfohlen, diese Option zu aktivieren, wenn Sie einen Reverse-Proxy verwenden.',
    'ALLOW_CUSTOM_CODE_IN_THEMES.title' => 'Benutzerdefinierten Code in Themes zulassen',
    'ALLOW_CUSTOM_CODE_IN_THEMES.description' => 'Ermöglicht die Verwendung von benutzerdefiniertem Code in Themes. Wenn Sie Themes aus unbekannten Quellen verwenden, kann dies ein Sicherheitsrisiko darstellen.',
    'ENABLE_ADMIN_BAR_USERS.title' => 'Aktivieren Sie die Adminleiste für alle Benutzer',
    'ENABLE_ADMIN_BAR_USERS.description' => 'Wenn aktiviert, wird die Adminleiste für alle authentifizierten Benutzer auf ihrer Linkseite angezeigt.',
    'ENABLE_THEME_UPDATER.title' => 'Aktivieren Sie den Theme-Updater',
    'ENABLE_THEME_UPDATER.description' => 'Legt fest, ob der Theme-Updater aktiv sein soll.',
    'ENABLE_SOCIAL_LOGIN.title' => 'Aktivieren Sie Social Login',
    'ENABLE_SOCIAL_LOGIN.description' => 'Aktiviert Oauth. Diese Option erfordert eine weitere Einrichtung. Lesen Sie mehr darüber <a target=\'_blank\' href=\'https://linkstack.org/social-login\'>hier</a>.',
    'USE_THEME_PREVIEW_IFRAME.title' => 'Verwenden Sie einen iframe als Theme-Vorschau',
    'USE_THEME_PREVIEW_IFRAME.description' => 'Legt fest, ob ein interner Iframe als Vorschau für die Themenseite verwendet werden soll.',
    'FORCE_ROUTE_HTTPS.title' => 'Leiten Sie alle Seiten auf HTTPS um',
    'FORCE_ROUTE_HTTPS.description' => 'Diese Option NICHT mit einem Reverse-Proxy verwenden!',
    'DISPLAY_FOOTER_TERMS.title' => 'Link zur Fußzeile der Nutzungsbedingungen',
    'DISPLAY_FOOTER_TERMS.description' => 'Fußzeilenlink „Bedingungen“ aktivieren.',
    'DISPLAY_FOOTER_PRIVACY.title' => 'Link zur Datenschutz-Fußzeile',
    'DISPLAY_FOOTER_PRIVACY.description' => 'Aktivieren Sie den Link „Datenschutz“.',
    'DISPLAY_FOOTER_CONTACT.title' => 'Link zur Kontaktfußzeile',
    'DISPLAY_FOOTER_CONTACT.description' => 'Kontaktlink aktivieren.',
    'TITLE_FOOTER_HOME.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_HOME.description' => 'Titel des Home-Fußzeilen-Links.',
    'TITLE_FOOTER_TERMS.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_TERMS.description' => 'Titel des Bedingungslinks.',
    'TITLE_FOOTER_PRIVACY.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_PRIVACY.description' => 'Titel des Datenschutzlinks.',
    'TITLE_FOOTER_CONTACT.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_CONTACT.description' => 'Titel des Kontaktlinks.',
    'HOME_FOOTER_LINK.title' => '<div style="margin-top:-40px">URL des Home-Fußzeilen-Links</div>',
    'HOME_FOOTER_LINK.description' => 'Geben Sie eine beliebige URL ein, um Ihre Home-Link-URL umzuleiten.<br>Leer lassen, um den Standardlink zu verwenden.',
    'ALLOW_CUSTOM_BACKGROUNDS.title' => 'Benutzerdefinierte Hintergründe zulassen',
    'ALLOW_CUSTOM_BACKGROUNDS.description' => 'Ermöglichen Sie Benutzern das Hochladen benutzerdefinierter Hintergrundbilder für Nutzerseiten.',
    'ALLOW_USER_IMPORT.title' => 'Erlauben Sie Benutzern, Profile aus anderen Instanzen zu importieren',
    'ALLOW_USER_IMPORT.description' => 'Ermöglicht Benutzern das Importieren ihres Profils und ihrer Links aus einer externen Datei.',
    'ALLOW_USER_EXPORT.title' => 'Erlauben Sie Benutzern, ihr Profil zu exportieren',
    'ALLOW_USER_EXPORT.description' => 'Ermöglicht Benutzern den Export ihrer eigenen Links und ihres Profils.',
    'MANUAL_USER_VERIFICATION.title' => 'Manuelle Nutzerüberprüfung',
    'MANUAL_USER_VERIFICATION.description' => 'Legt fest, ob Administratoren neu registrierte Benutzer manuell überprüfen müssen.',
    'ADMIN_EMAIL.title' => 'Admin-E-Mail',
    'ADMIN_EMAIL.description' => 'Wird zum Versenden von Benachrichtigungs-E-Mails verwendet.',
    'HIDE_VERIFICATION_CHECKMARK.title' => 'Verifizierungshäkchen ausblenden',
    'HIDE_VERIFICATION_CHECKMARK.description' => 'Versteckt das Verifizierungsabzeichen, das auf Admin- und VIP-Seiten angezeigt wird.',
    'ENABLE_REPORT_ICON.title' => 'Report-Icon aktivieren',
    'ENABLE_REPORT_ICON.description' => 'Zeigt ein Symbol auf Benutzerseiten an, das es Benutzern ermöglicht, Seiten zu melden.',
    'LOCALE.title' => 'App Lokalisierung',
    'LOCALE.description' => 'Ändern Sie die Sprache Ihrer Anwendung.',


    /*
    |--------------------------------------------------------------------------
    | Installer
    |--------------------------------------------------------------------------
    |
    | resources/views/installer/installer.blade.php
    |
    */

    # Title Tag
    'LinkStack setup' => 'LinkStack-Setup',

    'Setup LinkStack' => 'Richten Sie LinkStack ein',
    'Welcome to the setup for LinkStack!' => 'Willkommen beim Setup für LinkStack!',
    'This setup will:' => 'Dieses Setup wird:',
    'Check the server dependencies' => '1. Überprüfen Sie die Serverabhängigkeiten',
    'Setup the database' => '2. Richten Sie die Datenbank ein',
    'Create the admin user' => '3. Erstellen Sie den Admin-Benutzer',
    'Configure the app' => '4. Konfigurieren Sie die App',
    'Choose a language' => 'Wählen Sie eine Sprache',
    'setup.disclaimer' => 'Es gelten unsere',
    'Terms and Conditions' => 'Allgemeinen Geschäftsbedingungen',

    'Next' => 'Weiter',
    'Yes' => 'Ja',
    'No' => 'NEIN',
    'Finish setup' => 'Beenden Sie die Einrichtung',

    'Setup failed' => 'Die Einrichtung ist fehlgeschlagen',
    'An error has occured. Please try again' => 'Ein Fehler ist aufgetreten. Bitte versuche es erneut.',
    'Depending on your database type:' => 'Abhängig von Ihrem Datenbanktyp:',
    'Try again' => 'Versuchen Sie es erneut',

    'Dependency check' => 'Abhängigkeitsprüfung',
    'Required PHP modules:' => 'Erforderliche PHP-Module:',

    'Select a database type' => 'Wählen Sie einen Datenbanktyp aus',
    'Under most circumstances, we recommend using SQLite' => 'In den meisten Fällen empfehlen wir die Verwendung von SQLite.',
    'MySQL requires a separate, empty MySQL database' => 'MySQL erfordert eine separate, leere MySQL-Datenbank.',

    'Database type:' => 'Datenbanktyp:',
    'Database host:' => 'Datenbankhost:',
    'Database port:' => 'Datenbankport:',
    'Database name:' => 'Name der Datenbank:',
    'Database username:' => 'Datenbankbenutzername:',
    'Database password:' => 'Datenbankpasswort:',

    'Create an admin account' => 'Erstellen Sie ein Administratorkonto.',
    'Admin email:' => 'Admin-E-Mail:',
    'Admin password:' => 'Administrator-Passwort:',
    'Handle:' => 'Handle:',
    'Name:' => 'Name:',

    'Configure your page' => 'Konfigurieren Sie Ihre Seite',
    'Enable registration:' => 'Registrierung aktivieren:',
    'Enable email verification:' => 'E-Mail-Bestätigung aktivieren:',
    'Set your page as Home Page' => 'Legen Sie Ihre Seite als Startseite fest',
    'This will move the Home Page to /home' => 'Dadurch wird die Startseite nach /home verschoben',
    'App Name:' => 'App Name:',


    /*
    |--------------------------------------------------------------------------
    | Updater/Update-Backup
    |--------------------------------------------------------------------------
    |
    | resources/views/update.blade.php
    |
    */

    # Title Tag
    'Update LinkStack' => 'LinkStack aktualisieren',

    'Latest beta version' => 'Neueste Beta-Version',
    'Installed beta version' => 'Installierte Beta-Version',
    'none' => 'keiner',
    'You need to update to the latest mainline release' => 'Sie müssen auf die neueste Hauptversion aktualisieren',
    'You’re running the latest mainline release' => 'Sie verwenden die neueste Hauptversion',

    'update.manually' => 'Sie können Ihre Installation automatisch aktualisieren oder das Update herunterladen und manuell installieren:',
    'update.windows' => 'Windows-Benutzer können den alternativen Updater verwenden. Dieser Updater erstellt kein Backup. Verwendung nach eigenem Ermessen.',
    'Update automatically' => 'Automatisch aktualisieren',

    'Updating' => 'Aktualisierung',
    'Creating backup' => 'Backup erstellen',
    'Preparing update' => 'Update wird vorbereitet',
    'No new version' => 'Keine neue Version',
    'There is no new version available' => 'Es ist keine neue Version verfügbar',
    'Admin Panel' => 'Administrationsmenü',
    'Finishing up' => 'Beenden',
    'Success!' => 'Erfolg!',
    'The update was successful' => 'Das Update war erfolgreich, Sie können nun zum Admin-Panel zurückkehren.',
    'View the release notes' => 'Sehen Sie sich die Versionshinweise an',
    'Run again' => 'Erneut updaten',
    'Error' => 'Error',
    'Something went wrong with the update' => 'Beim Update ist ein Fehler aufgetreten',

    
    /*
    |--------------------------------------------------------------------------
    | Backup
    |--------------------------------------------------------------------------
    |
    | resources/views/backup.blade.php
    |
    */

    # Title Tag
    'Backup.title' => 'Sicherung',

    'Backup' => 'Backup',

    'The backup system won’t save more than two backups at a time' => 'Das Sicherungssystem speichert nicht mehr als zwei Backups.',
    'Backup Instance' => 'Instanz sichern',
    'Creating backup' => 'Backup wird erstellt',
    'The backup was successful' => 'Die Backup wurde erfolgreich erstellt. Sie können nun zum Administrationsbereich zurückkehren oder alle Ihre Backups anzeigen.',    


    /*
    |--------------------------------------------------------------------------
    | Page Blocks
    |--------------------------------------------------------------------------
    |
    | Parts are stored in the database.
    | resources/views/studio/edit-link.blade.php
    |
    */

    # predefined
    'block.title.predefined' => 'Vordefinierte Site',
    'block.description.predefined' => 'Wählen Sie aus einer Liste vordefinierter Websites aus und lassen Sie Ihren Link automatisch mit den Markenfarben und dem Symbol dieser Website gestalten.',

    # link
    'block.title.link' => 'Benutzerdefinierten Link',
    'block.description.link' => 'Erstellen Sie einen benutzerdefinierten Link, der zu einer beliebigen Website führt. Passen Sie den Stil und das Symbol der Schaltfläche an oder verwenden Sie das Favicon von der Website als Schaltflächensymbol.',

    # vcard
    'block.title.vcard' => 'Vcard',
    'block.description.vcard' => 'Erstellen Sie eine elektronische Visitenkarte oder laden Sie sie hoch.',

    # email
    'block.title.email' => 'E-Mail-Addresse',
    'block.description.email' => 'Fügen Sie eine E-Mail hinzu, die einen Systemdialog zum Verfassen einer neuen E-Mail öffnet.',

    # telephone
    'block.title.telephone' => 'Telefonnummer',
    'block.description.telephone' => 'Fügen Sie eine Telefonnummer hinzu, die einen Systemdialog zum Einleiten eines Telefonanrufs öffnet.',

    # heading
    'block.title.heading' => 'Überschrift',
    'block.description.heading' => 'Verwenden Sie Überschriften, um Ihre Links zu organisieren und sie in Gruppen zu unterteilen.',

    # spacer
    'block.title.spacer' => 'Abstandshalter',
    'block.description.spacer' => 'Fügen Sie Ihrer Linkliste Leerzeichen hinzu. Sie können wählen, wie hoch.',

    # text
    'block.title.text' => 'Text',
    'block.description.text' => 'Fügen Sie Ihrer Seite statischen Text hinzu, der nicht anklickbar ist.',


    /*
    |--------------------------------------------------------------------------
    | Page Items
    |--------------------------------------------------------------------------
    |
    | resources/views/components/pageitems/
    |
    */

    'Default Email' => 'Standard-E-Mail',
    'Custom Title' => 'Benutzerdefinierter Titel',
    'Leave blank for default title' => 'Für den Standardtitel leer lassen',
    'E-Mail address' => 'E-Mail-Addresse',
    'Enter your E-Mail' => 'Geben sie ihre E-Mail Adresse ein',

    'Heading Text:' => 'Überschriftentext:',

    'URL' => 'URL',
    'Show website icon on button' => 'Website-Symbol anzeigen',

    'Select a predefined site' => 'Wählen Sie eine vordefinierte Site aus',
    'Enter the link URL' => 'Geben Sie die Link-URL ein',

    'Spacing height' => 'Abstandshöhe',

    'Phone' => 'Telefon',
    'Telephone number' => 'Telefonnummer',
    'Enter your telephone number' => 'Geben Sie Ihre Telefonnummer ein',

    'Text to display' => 'Text, der angezeigt werden soll',

    'Vcard' => 'Vcard',
    'First Name' => 'Vorname',
    'Middle Name' => 'Zweiter Vorname',
    'Last Name' => 'Familienname, Nachname',
    'Suffix' => 'Suffix',
    'Work' => 'Arbeiten',
    'Organization' => 'Organisation',
    'Work URL' => 'Arbeits-URL',
    'Emails' => 'E-Mails',
    'Enter your personal email' => 'Geben Sie Ihre persönliche E-Mail-Adresse ein',
    'Work Email' => 'Arbeits Email',
    'Enter your work email' => 'Geben Sie Ihre geschäftliche E-Mail-Adresse ein',
    'Phones' => 'Telefone',
    'Home Phone' => 'Festnetztelefon',
    'Work Phone' => 'Arbeitshandy',
    'Cell Phone' => 'Handy',
    'Home Address' => 'Heimatadresse',
    'Label' => 'Etikett',
    'Street' => 'Straße',
    'City' => 'Stadt',
    'State/Province' => 'Staat/Provinz',
    'Zip/Postal Code' => 'Postleitzahl',
    'Country' => 'Land',
    'Work Address' => 'Arbeitsadresse',

    'URL to the video' => 'URL zum Video',


    /*
    |--------------------------------------------------------------------------
    | Maintenance Page
    |--------------------------------------------------------------------------
    |
    | resources/views/mainenance.blade.php
    |
    */

    'Maintenance Mode' => 'Wartungsmodus',
    'We are performing scheduled site maintenance at this time' => 'Wir führen derzeit planmäßige Wartungsarbeiten an der Website durch.',
    'Please check back with us later' => 'Bitte schauen Sie später noch einmal bei uns vorbei.',
    'Admin options:' => 'Admin-Optionen:',
    'Turn off' => 'Abschalten',
    'Warn.Disable.Maintenance' => 'Sie sind dabei, den Wartungsmodus zu deaktivieren. Bist du dir sicher?',


    /*
    |--------------------------------------------------------------------------
    | LinkStack (Links) Page
    |--------------------------------------------------------------------------
    |
    | resources/views/littlelink.blade.php
    |
    */

    'Share this page' => 'Teile diese Seite',
    'Share' => 'Teilen',
    'Copy URL to clipboard' => 'URL in die Zwischenablage kopieren',
    'URL has been copied to your clipboard!' => 'Die URL wurde in Ihre Zwischenablage kopiert!',

    'Delete User' => 'Benutzer löschen',
    'Block User' => 'Benutzer blockieren',
    'Users Theme' => 'Theme',
    'Search User' => 'Nach Benutzer Suchen',
    
    'Edit my profile' => 'Profil editieren',

    /*
    |--------------------------------------------------------------------------
    | Footer
    |--------------------------------------------------------------------------
    |
    | Added to the bottom of certain pages.
    | resources/views/layouts/footer.blade.php
    |
    */

    'Learn more about LinkStack' => 'Erfahren Sie mehr über LinkStack',
    'Learn more' => 'Erfahren Sie mehr',

    /*
    |--------------------------------------------------------------------------
    | Notification messages
    |--------------------------------------------------------------------------
    |
    | All internal notifications.
    | resources/views/layouts/notifications.blade.php
    |
    */

    'No notifications' => 'Keine Benachrichtigungen',

    # Security Risk Notification
    'Your security is at risk!' => 'Ihre Sicherheit ist gefährdet!',
    'Immediate action is required!' => 'Sofortiges Handeln ist erforderlich!',
    'security.msg1' => 'Ihre Sicherheit ist gefährdet.',
    'security.msg2' => 'Einige Dateien können von jedem eingesehen werden. Sofortiges Handeln ist erforderlich!',
    'security.msg3' => 'Einige wichtige Dateien sind öffentlich zugänglich und gefährden Ihre Sicherheit. Bitte ergreifen Sie sofort Maßnahmen, um den öffentlichen Zugriff auf diese Dateien zu widerrufen und unbefugten Zugriff auf Ihre sensiblen Informationen zu verhindern.',
    'security.msg4' => 'Erfahren Sie mehr',    

    # Help Us Out Notification
    'Hide this notification' => 'Diese Benachrichtigung ausblenden',
    'Help Us Out' => 'Helfen Sie uns',
    'Enjoying Linkstack?' => 'Gefällt Ihnen Linkstack?',
    'Support Linkstack' => 'Unterstützen Sie Linkstack',
    'support.msg1' => 'Wenn Ihnen die Verwendung von Linkstack gefällt, würden wir es sehr schätzen, wenn Sie sich einen Moment Zeit nehmen könnten, um',
    'support.msg2' => 'unserem Projekt auf GitHub einen Stern zu geben',
    'support.msg3' => 'Ihre Unterstützung wird uns helfen, ein größeres Publikum zu erreichen und die Qualität unseres Projekts zu verbessern.',
    'support.msg4' => 'Wenn Sie in der Lage sind,',
    'support.msg5' => 'einen finanziellen Beitrag zu leisten</a>, würde uns selbst ein kleiner Betrag helfen, die Kosten für die Aufrechterhaltung und Verbesserung von Linkstack zu decken.',
    'support.msg6' => 'Vielen Dank für Ihre Unterstützung und dafür, Teil der LinkStack-Community zu sein!',
    

    /*
    |--------------------------------------------------------------------------
    | Footer Links
    |--------------------------------------------------------------------------
    |
    */

    'footer.Home' => 'Startseite',
    'footer.Terms' => 'AGB',
    'footer.Privacy' => 'Datenschutz',
    'footer.Contact' => 'Kontakt',


    /*
    |--------------------------------------------------------------------------
    | Report Page
    |--------------------------------------------------------------------------
    |
    */

    'report_violation' => 'Verstoß melden',
    'url_label' => 'URL der gemeldeten Website',
    'report_type_label' => 'Art des Reports',
    'hate_speech' => 'Hassrede oder Belästigung',
    'violence_threats' => 'Gewalt oder Drohungen',
    'illegal_activities' => 'Illegale Aktivitäten',
    'copyright_infringement' => 'Verletzung von Urheberrechten',
    'misinformation_fake_news' => 'Fehlinformationen oder Fake News',
    'identity_theft' => 'Identitätsdiebstahl',
    'drug_related_content' => 'Inhalte im Zusammenhang mit Drogen',
    'weapons_harmful_objects' => 'Waffen oder schädliche Objekte',
    'child_exploitation' => 'Kindesausbeutung',
    'fraud_scams' => 'Betrug oder Betrugsversuche',
    'privacy_violation' => 'Verletzung der Privatsphäre',
    'impersonation' => 'Identitätswechsel',
    'other_specify' => 'Sonstiges (bitte angeben)',
    'additional_comments_label' => 'Zusätzliche Kommentare',
    'submit_button' => 'Absenden',
    
    'report_mail_admin_subject' => 'Profil-Report',
    'report_mail_admin_report' => 'Ein Profil wurde gemeldet',
    
    'report_mail_reported_profile' => 'Gemeldetes Profil',
    'report_mail_reported_url' => 'Gemeldete URL',
    'report_mail_type' => 'Art',
    'report_mail_message' => 'Nachricht',
    
    'report_mail_report_submitted_by' => 'Report eingereicht von',
    'report_mail_reported_by' => 'Gemeldet von',
    'report_mail_profile' => 'Profil',
    
    'report_mail_button_profile' => 'Auf Benutzerseite anzeigen',
    'report_mail_button_delete' => 'Gemeldeten Benutzer löschen',
    
    'report_error' => 'Profil konnte nicht gemeldet werden',
    'report_success' => 'Profil wurde erfolgreich gemeldet',


    #=============================================================================#
    # Laravel internal translations                                               #
    #=============================================================================#


    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    'failed' => 'Diese Anmeldeinformationen stimmen nicht mit unseren Unterlagen überein.',
    'password' => 'Das angegebene Passwort ist falsch.',
    'throttle' => 'Zu viele Anmeldeversuche. Bitte versuchen Sie es in :Sekunden Sekunden erneut.',


    /*
    |--------------------------------------------------------------------------
    | Pagination Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the paginator library to build
    | the simple pagination links. You are free to change them to anything
    | you want to customize your views to better match your application.
    |
    */

    'previous' => '&laquo; Vorherige',
    'next' => 'Nächste &raquo;',


];
